<?php

namespace App\Http\Resources;

use App\Models\Flat;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Flat */
class FlatResource extends JsonResource
{
    public function toArray(Request $request) {
        return [
            'id' => $this->id,
            'flat_no' => $this->flat_no,
            'status' => $this->status,
            'flat_sqrft' => $this->flat_sqrft,
            'agreement' => $this->agreement,
            'other_docs' => $this->other_docs,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

            'wing_id' => $this->wing_id,
            'owner_id' => $this->owner_id,

            'wing' => new WingResource($this->whenLoaded('wing')),
            'owner' => new OwnerResource($this->whenLoaded('owner')),
        ];
    }
}
