<?php

namespace App\Http\Requests\User;

use App\Enums\UserRole;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class RegisterUserRequest extends FormRequest
{
    public function rules() {
        return [
            'owner_id' => ['nullable', 'exists:owners,id'],
            'flat_id' => ['nullable', 'exists:flats,id'],
            'name' => ['required', 'string'],
            'email' => [
                'required', 'email', 'max:254',
                Rule::unique('users', 'email')
            ],
            'phone' => ['required', 'string'],
            'password' => ['required', 'string', 'confirmed'],
            'role' => ['required', Rule::enum(UserRole::class)],
        ];
    }

    public function authorize() {
        return true;
    }
}
