<?php

namespace App\Http\Resources;

use App\Models\PatrollingLocation;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin PatrollingLocation */
class PatrollingLocationResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'type' => $this->type,
            'location_code' => $this->location_code,
            'description' => $this->description,
            'is_active' => $this->is_active,
            'coordinates' => $this->coordinates,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

            'wing_id' => $this->wing_id,

            'wing' => new WingResource($this->whenLoaded('wing')),
        ];
    }
}