<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patrol_rounds', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., "Morning Round", "Evening Round"
            $table->time('start_time'); // Expected start time (HH:MM)
            $table->time('end_time'); // Expected end time (HH:MM)
            $table->boolean('is_active')->default(true);
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patrol_rounds');
    }
};
