<?php

namespace App\Http\Resources;

use App\Models\PatrollingLog;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin PatrollingLog */
class PatrollingLogResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'patrol_date' => $this->patrol_date,
            'patrol_time' => $this->patrol_time,
            'status' => $this->status,
            'notes' => $this->notes,
            'issues_found' => $this->issues_found,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

            'location_id' => $this->location_id,
            'guard_id' => $this->guard_id,
            'daily_patrol_summary_id' => $this->daily_patrol_summary_id,

            'location' => new PatrollingLocationResource($this->whenLoaded('location')),
            'guard' => new UserResource($this->whenLoaded('guardUser')),
            'daily_patrol_summary' => new DailyPatrolSummaryResource($this->whenLoaded('dailyPatrolSummary')),
            'patrol_round' => new PatrolRoundResource($this->whenLoaded('dailyPatrolSummary.patrolRound')),
        ];
    }
}
