<?php

namespace App\Http\Resources;

use App\Models\Wing;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Wing */
class WingResource extends JsonResource
{
    public function toArray(Request $request) {
        return [
            'id' => $this->id,

            'name' => $this->name,
            'no_floors' => $this->no_floors,
            'no_flats' => $this->no_flats,
            'no_lifts' => $this->no_lifts,
            'fire_extinguisher_date' => $this->fire_extinguisher_date,

            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
